local WhiteStroke = color("1,1,1,0.5");
InitUserPrefs();

local t = Def.ActorFrame {
	AutoText("frutiger") .. {
		Name="SMVersion";
		InitCommand=cmd(x,SCREEN_RIGHT-20;y,SCREEN_TOP+20;horizalign,right;shadowlength,0;strokecolor,WhiteStroke;zoom,0.6;diffuse,color("0,0,0,1"));
		BeginCommand=function(self)
			local versionText = ProductID().." "..ProductVersion();
			if SSC then
				versionColor = color("0,0.1,0.35,1")
				if VersionDate() and VersionTime() then
					versionText = versionText .." (".. VersionDate() .." @ "..VersionTime()..")";
				end;
				self:diffusetopedge( color("0.1,0.4,0.8,1") );
			else
				if VersionTime() then
					versionText = versionText .." (built on "..VersionTime()..")";
				end;
			end;
			self:settext(versionText);
		end;
	};

	AutoText("frutiger") .. {
		Name="Date";
		Text="Today is ".. MonthOfYear()+1 .. "/" .. DayOfMonth() .. "/" .. Year() ..".";
		InitCommand=cmd(x,SCREEN_RIGHT-20;y,SCREEN_TOP+36;horizalign,right;shadowlength,0;strokecolor,WhiteStroke);
		BeginCommand=function(self)
			if MonthOfYear()+1 == 7 and DayOfMonth() == 11 then
				self:settext("OMG FREE SLURPEES AT 7-11");
			end;
		end;
		OnCommand=cmd(diffuse,color("0,0,0,1");zoom,0.6);
	};
	AutoText("frutiger") .. {
		Name="Clock";
		InitCommand=cmd(x,SCREEN_RIGHT-20;y,SCREEN_TOP+52;horizalign,right;shadowlength,0;strokecolor,WhiteStroke);
		OnCommand=cmd(diffuse,color("0,0,0,1");zoom,0.6);
	};
	AutoText("frutiger") .. {
		Name="Network";
		InitCommand=cmd(x,SCREEN_RIGHT-20;y,SCREEN_TOP+68;horizalign,right;shadowlength,0;strokecolor,WhiteStroke);
		BeginCommand=function(self)
			if IsNetConnected() then
				self:settext("Network OK!");
			else
				self:settext("Offline");
			end
		end;
		OnCommand=cmd(diffuse,color("0,0,0,1");zoom,0.6;);
	};

	Def.ActorFrame{
		Name="AvailableData";
		InitCommand=cmd(x,SCREEN_LEFT+10;y,SCREEN_TOP+16);
		OnCommand=cmd(playcommandonchildren,"Align");
		AlignCommand=cmd(horizalign,left);

		AutoText("frutiger") .. {
			Name="SongNum";
			Text=SONGMAN:GetNumSongs();
			InitCommand=cmd(shadowlength,0;diffuse,color("#FF0000");skewx,-0.2;zoom,0.8;strokecolor,color("#66000000"));
		};
		AutoText("frutiger") .. {
			Name="SongText";
			InitCommand=cmd(shadowlength,0;diffuse,color("#000000");zoom,0.6;strokecolor,WhiteStroke);
			OnCommand=function(self)
				local num = self:GetParent():GetChild("SongNum"):GetWidth()
				self:x(num-2)
				local text = "songs";
				if SONGMAN:GetNumSongs() == 1 then text= "song" end;
				self:settext(text);
			end;
		};

		AutoText("frutiger") .. {
			Name="GroupNum";
			Text=SONGMAN:GetNumSongGroups();
			InitCommand=cmd(addy,16;shadowlength,0;diffuse,color("#FF0000");skewx,-0.2;zoom,0.8;strokecolor,color("#66000000"));
		};
		AutoText("frutiger") .. {
			Name="GroupText";
			InitCommand=cmd(addy,16;shadowlength,0;diffuse,color("#000000");zoom,0.6;strokecolor,WhiteStroke);
			OnCommand=function(self)
				local num = self:GetParent():GetChild("GroupNum"):GetWidth()
				self:x(num+2)
				local text = "group";
				if SONGMAN:GetNumSongs() >= 1 then text = text .. "s" end;
				self:settext(text);
			end;
		};

		AutoText("frutiger") .. {
			Name="CourseNum";
			Text=SONGMAN:GetNumCourses();
			InitCommand=cmd(addy,32;shadowlength,0;diffuse,color("#FF0000");skewx,-0.2;zoom,0.8;strokecolor,color("#66000000"));
		};
		AutoText("frutiger") .. {
			Name="CourseText";
			InitCommand=cmd(addy,32;shadowlength,0;diffuse,color("#000000");zoom,0.6;strokecolor,WhiteStroke);
			OnCommand=function(self)
				local num = self:GetParent():GetChild("CourseNum"):GetWidth()
				self:x(num+2)
				local text = "courses";
				if SONGMAN:GetNumCourses() == 1 then text = "course" end;
				self:settext(text);
			end;
		};
	};

	AutoText("frutiger") .. {
		Name="Gametype";
		Text="Gametype: "..GAMESTATE:GetCurrentGame():GetName();
		InitCommand=cmd(x,SCREEN_LEFT+10;y,SCREEN_TOP+64;horizalign,left;shadowlength,0;strokecolor,WhiteStroke);
		OnCommand=cmd(diffuse,color("0,0,0,1");zoom,0.6);
	};

	LoadActor("prefs")..{
		InitCommand=cmd(x,SCREEN_RIGHT+SCREEN_CENTER_X;y,SCREEN_CENTER_Y-72;horizalign,right);
		CodeMessageCommand=function(self,param)
			if param.Name == "SelectPress" then
				self:bouncebegin(0.375);
				self:x(SCREEN_RIGHT-124);
				self:sleep(5);
				self:bouncebegin(0.375);
				self:x(SCREEN_RIGHT+SCREEN_CENTER_X);
			end;
		end;
	};
};

local function Update(self)
	local clock = self:GetChild("Clock");

	local hour = Hour();
	local min = Minute();
	local sec = Second();
	clock:settext( "It's currently ".. string.format( '%02i:%02i:%02i', hour, min, sec ).. "." );
	--[[
	if(hour == 4 or hour == 16) and min == 20 then
		clock:diffuse( color("0,0.8,0,1") );
	else
		clock:diffuse( color("0,0,0,1") );
	end;
	]]
end;

t.InitCommand=cmd(SetUpdateFunction,Update)

return t;